using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Data;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgTransfusionReportCriteria
	/// </summary>
	public class DlgTransfusionReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpDivisions;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.RadioButton rdoTreatingSpecialty;
		private System.Windows.Forms.RadioButton rdoIssuingPhysician;
		private System.Windows.Forms.GroupBox grpTreatingSpecialties;
		private System.Windows.Forms.CheckedListBox lbTreatingSpecialties;
		private System.Windows.Forms.Button btnSelectAllSpecialties;
		private System.Windows.Forms.Button btnDeselectAllSpecialties;
		private System.Windows.Forms.GroupBox grpIssuingPhysicians;
		private System.Windows.Forms.Button btnSelectAllPhysicians;
		private System.Windows.Forms.Button btnDeselectAllPhysicians;
		private System.Windows.Forms.CheckedListBox lbIssuingPhysicians;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private System.Windows.Forms.RadioButton rdoIssuedToLocation;
		private System.Windows.Forms.GroupBox grpIssuedToLocations;
		private System.Windows.Forms.CheckedListBox lbIssuedToLocations;
		private System.Windows.Forms.Button btnSelectAllLocations;
		private System.Windows.Forms.Button btnDeselectAllLocations;
		private System.ComponentModel.IContainer components = null;
		private Form _mdiParent;
		private va.med.vbecs.BOL.TransfusionReport _report;
		private Common.TransfusionReportType reportType = Common.TransfusionReportType.Physician;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="mdiParent"></param>
		public DlgTransfusionReportCriteria(Form mdiParent)
		{
			this._report=new gov.va.med.vbecs.BOL.TransfusionReport();

			// This call is required by the Windows Form Designer.
			InitializeComponent();
			
			SetComponentProperties();

			this._mdiParent = mdiParent;

			this.LoadIssueToLocations();
			this.LoadPhysicians();
			this.LoadSpecialties();
			this.LoadPrinters();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgTransfusionReportCriteria));
			this.grpDivisions = new System.Windows.Forms.GroupBox();
			this.rdoIssuedToLocation = new System.Windows.Forms.RadioButton();
			this.rdoTreatingSpecialty = new System.Windows.Forms.RadioButton();
			this.rdoIssuingPhysician = new System.Windows.Forms.RadioButton();
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpTreatingSpecialties = new System.Windows.Forms.GroupBox();
			this.btnSelectAllSpecialties = new System.Windows.Forms.Button();
			this.btnDeselectAllSpecialties = new System.Windows.Forms.Button();
			this.lbTreatingSpecialties = new System.Windows.Forms.CheckedListBox();
			this.grpIssuingPhysicians = new System.Windows.Forms.GroupBox();
			this.lbIssuingPhysicians = new System.Windows.Forms.CheckedListBox();
			this.btnSelectAllPhysicians = new System.Windows.Forms.Button();
			this.btnDeselectAllPhysicians = new System.Windows.Forms.Button();
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.grpIssuedToLocations = new System.Windows.Forms.GroupBox();
			this.lbIssuedToLocations = new System.Windows.Forms.CheckedListBox();
			this.btnSelectAllLocations = new System.Windows.Forms.Button();
			this.btnDeselectAllLocations = new System.Windows.Forms.Button();
			this.grpDivisions.SuspendLayout();
			this.grpDateRange.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpTreatingSpecialties.SuspendLayout();
			this.grpIssuingPhysicians.SuspendLayout();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.grpIssuedToLocations.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(424, 30);
			this.vbecsLogo1.TabIndex = 8;
			this.vbecsLogo1.Title = "Division Transfusion Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 449);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 10;
			// 
			// grpDivisions
			// 
			this.grpDivisions.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDivisions.Controls.Add(this.rdoIssuedToLocation);
			this.grpDivisions.Controls.Add(this.rdoTreatingSpecialty);
			this.grpDivisions.Controls.Add(this.rdoIssuingPhysician);
			this.grpDivisions.Location = new System.Drawing.Point(60, 84);
			this.grpDivisions.Name = "grpDivisions";
			this.grpDivisions.Size = new System.Drawing.Size(360, 80);
			this.grpDivisions.TabIndex = 1;
			this.grpDivisions.TabStop = false;
			this.grpDivisions.Text = "Report Type*";
			// 
			// rdoIssuedToLocation
			// 
			this.rdoIssuedToLocation.Location = new System.Drawing.Point(12, 56);
			this.rdoIssuedToLocation.Name = "rdoIssuedToLocation";
			this.rdoIssuedToLocation.Size = new System.Drawing.Size(164, 20);
			this.rdoIssuedToLocation.TabIndex = 2;
			this.rdoIssuedToLocation.Text = "Issued-To &Location Report";
			// 
			// rdoTreatingSpecialty
			// 
			this.rdoTreatingSpecialty.Location = new System.Drawing.Point(12, 36);
			this.rdoTreatingSpecialty.Name = "rdoTreatingSpecialty";
			this.rdoTreatingSpecialty.Size = new System.Drawing.Size(164, 20);
			this.rdoTreatingSpecialty.TabIndex = 1;
			this.rdoTreatingSpecialty.Text = "&Treating Specialty Report";
			// 
			// rdoIssuingPhysician
			// 
			this.rdoIssuingPhysician.Checked = true;
			this.rdoIssuingPhysician.Location = new System.Drawing.Point(12, 16);
			this.rdoIssuingPhysician.Name = "rdoIssuingPhysician";
			this.rdoIssuingPhysician.Size = new System.Drawing.Size(164, 20);
			this.rdoIssuingPhysician.TabIndex = 0;
			this.rdoIssuingPhysician.TabStop = true;
			this.rdoIssuingPhysician.Text = "&Issuing Physician Report";
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Location = new System.Drawing.Point(60, 32);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(360, 48);
			this.grpDateRange.TabIndex = 0;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Report Date Range";
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(196, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(84, 20);
			this.dtpStartDate.TabIndex = 1;
			this.dtpStartDate.Value = new System.DateTime(2004, 4, 7, 0, 0, 0, 0);
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(252, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(84, 20);
			this.dtpEndDate.TabIndex = 3;
			this.dtpEndDate.Value = new System.DateTime(2004, 4, 7, 0, 0, 0, 0);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(264, 432);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 6;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(344, 432);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 7;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 392);
			this.grpImage.TabIndex = 9;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 1;
			this.pictureBox1.TabStop = false;
			// 
			// grpTreatingSpecialties
			// 
			this.grpTreatingSpecialties.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTreatingSpecialties.Controls.Add(this.btnSelectAllSpecialties);
			this.grpTreatingSpecialties.Controls.Add(this.btnDeselectAllSpecialties);
			this.grpTreatingSpecialties.Controls.Add(this.lbTreatingSpecialties);
			this.grpTreatingSpecialties.Location = new System.Drawing.Point(60, 168);
			this.grpTreatingSpecialties.Name = "grpTreatingSpecialties";
			this.grpTreatingSpecialties.Size = new System.Drawing.Size(360, 132);
			this.grpTreatingSpecialties.TabIndex = 3;
			this.grpTreatingSpecialties.TabStop = false;
			this.grpTreatingSpecialties.Text = "Include Treating Specialties*";
			// 
			// btnSelectAllSpecialties
			// 
			this.btnSelectAllSpecialties.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectAllSpecialties.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSelectAllSpecialties.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllSpecialties.Image")));
			this.btnSelectAllSpecialties.Location = new System.Drawing.Point(336, 0);
			this.btnSelectAllSpecialties.Name = "btnSelectAllSpecialties";
			this.btnSelectAllSpecialties.Size = new System.Drawing.Size(16, 16);
			this.btnSelectAllSpecialties.TabIndex = 2;
			// 
			// btnDeselectAllSpecialties
			// 
			this.btnDeselectAllSpecialties.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselectAllSpecialties.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDeselectAllSpecialties.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllSpecialties.Image")));
			this.btnDeselectAllSpecialties.Location = new System.Drawing.Point(320, 0);
			this.btnDeselectAllSpecialties.Name = "btnDeselectAllSpecialties";
			this.btnDeselectAllSpecialties.Size = new System.Drawing.Size(16, 16);
			this.btnDeselectAllSpecialties.TabIndex = 1;
			// 
			// lbTreatingSpecialties
			// 
			this.lbTreatingSpecialties.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lbTreatingSpecialties.CheckOnClick = true;
			this.lbTreatingSpecialties.ColumnWidth = 200;
			this.lbTreatingSpecialties.Location = new System.Drawing.Point(8, 16);
			this.lbTreatingSpecialties.MultiColumn = true;
			this.lbTreatingSpecialties.Name = "lbTreatingSpecialties";
			this.lbTreatingSpecialties.Size = new System.Drawing.Size(344, 109);
			this.lbTreatingSpecialties.TabIndex = 0;
			// 
			// grpIssuingPhysicians
			// 
			this.grpIssuingPhysicians.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpIssuingPhysicians.Controls.Add(this.lbIssuingPhysicians);
			this.grpIssuingPhysicians.Controls.Add(this.btnSelectAllPhysicians);
			this.grpIssuingPhysicians.Controls.Add(this.btnDeselectAllPhysicians);
			this.grpIssuingPhysicians.Location = new System.Drawing.Point(60, 168);
			this.grpIssuingPhysicians.Name = "grpIssuingPhysicians";
			this.grpIssuingPhysicians.Size = new System.Drawing.Size(360, 132);
			this.grpIssuingPhysicians.TabIndex = 2;
			this.grpIssuingPhysicians.TabStop = false;
			this.grpIssuingPhysicians.Text = "Include Issuing Physicians*";
			// 
			// lbIssuingPhysicians
			// 
			this.lbIssuingPhysicians.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lbIssuingPhysicians.CheckOnClick = true;
			this.lbIssuingPhysicians.ColumnWidth = 200;
			this.lbIssuingPhysicians.Location = new System.Drawing.Point(8, 16);
			this.lbIssuingPhysicians.MultiColumn = true;
			this.lbIssuingPhysicians.Name = "lbIssuingPhysicians";
			this.lbIssuingPhysicians.Size = new System.Drawing.Size(344, 109);
			this.lbIssuingPhysicians.TabIndex = 0;
			// 
			// btnSelectAllPhysicians
			// 
			this.btnSelectAllPhysicians.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectAllPhysicians.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSelectAllPhysicians.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllPhysicians.Image")));
			this.btnSelectAllPhysicians.Location = new System.Drawing.Point(336, 0);
			this.btnSelectAllPhysicians.Name = "btnSelectAllPhysicians";
			this.btnSelectAllPhysicians.Size = new System.Drawing.Size(16, 16);
			this.btnSelectAllPhysicians.TabIndex = 2;
			// 
			// btnDeselectAllPhysicians
			// 
			this.btnDeselectAllPhysicians.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselectAllPhysicians.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDeselectAllPhysicians.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllPhysicians.Image")));
			this.btnDeselectAllPhysicians.Location = new System.Drawing.Point(320, 0);
			this.btnDeselectAllPhysicians.Name = "btnDeselectAllPhysicians";
			this.btnDeselectAllPhysicians.Size = new System.Drawing.Size(16, 16);
			this.btnDeselectAllPhysicians.TabIndex = 1;
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 304);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(360, 120);
			this.grpReportCompilation.TabIndex = 5;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 40);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 40);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(344, 72);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(240, 22);
			this.cmbPrinterName.TabIndex = 3;
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.CustomFormat = "MM/dd/yyyy hh:mm";
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(240, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			// 
			// grpIssuedToLocations
			// 
			this.grpIssuedToLocations.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpIssuedToLocations.Controls.Add(this.lbIssuedToLocations);
			this.grpIssuedToLocations.Controls.Add(this.btnSelectAllLocations);
			this.grpIssuedToLocations.Controls.Add(this.btnDeselectAllLocations);
			this.grpIssuedToLocations.Location = new System.Drawing.Point(60, 168);
			this.grpIssuedToLocations.Name = "grpIssuedToLocations";
			this.grpIssuedToLocations.Size = new System.Drawing.Size(360, 132);
			this.grpIssuedToLocations.TabIndex = 4;
			this.grpIssuedToLocations.TabStop = false;
			this.grpIssuedToLocations.Text = "Include Issued-To Locations*";
			// 
			// lbIssuedToLocations
			// 
			this.lbIssuedToLocations.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lbIssuedToLocations.CheckOnClick = true;
			this.lbIssuedToLocations.ColumnWidth = 200;
			this.lbIssuedToLocations.Location = new System.Drawing.Point(8, 16);
			this.lbIssuedToLocations.MultiColumn = true;
			this.lbIssuedToLocations.Name = "lbIssuedToLocations";
			this.lbIssuedToLocations.Size = new System.Drawing.Size(344, 109);
			this.lbIssuedToLocations.TabIndex = 0;
			// 
			// btnSelectAllLocations
			// 
			this.btnSelectAllLocations.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectAllLocations.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSelectAllLocations.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllLocations.Image")));
			this.btnSelectAllLocations.Location = new System.Drawing.Point(336, 0);
			this.btnSelectAllLocations.Name = "btnSelectAllLocations";
			this.btnSelectAllLocations.Size = new System.Drawing.Size(16, 16);
			this.btnSelectAllLocations.TabIndex = 2;
			// 
			// btnDeselectAllLocations
			// 
			this.btnDeselectAllLocations.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselectAllLocations.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDeselectAllLocations.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllLocations.Image")));
			this.btnDeselectAllLocations.Location = new System.Drawing.Point(320, 0);
			this.btnDeselectAllLocations.Name = "btnDeselectAllLocations";
			this.btnDeselectAllLocations.Size = new System.Drawing.Size(16, 16);
			this.btnDeselectAllLocations.TabIndex = 1;
			// 
			// DlgTransfusionReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(424, 465);
			this.Controls.Add(this.grpDivisions);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.grpDateRange);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpIssuedToLocations);
			this.Controls.Add(this.grpIssuingPhysicians);
			this.Controls.Add(this.grpTreatingSpecialties);
			this.hlphelpChm.SetHelpKeyword(this, "Division_Transfusion_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(432, 492);
			this.Name = "DlgTransfusionReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Division Transfusion Report";
			this.Controls.SetChildIndex(this.grpTreatingSpecialties, 0);
			this.Controls.SetChildIndex(this.grpIssuingPhysicians, 0);
			this.Controls.SetChildIndex(this.grpIssuedToLocations, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpDateRange, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.Controls.SetChildIndex(this.grpDivisions, 0);
			this.grpDivisions.ResumeLayout(false);
			this.grpDateRange.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpTreatingSpecialties.ResumeLayout(false);
			this.grpIssuingPhysicians.ResumeLayout(false);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.grpIssuedToLocations.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC074.DlgTransfusionReportCriteria());
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			//
			this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//BR_77.01
			this.dtpEndDate.Value = this._report.EndDate;
			this.dtpStartDate.Value = this._report.StartDate;
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpPrintDate.Value = _currentDate;
			this.grpIssuingPhysicians.BringToFront();

			// Added 1/5/05 RDH 
			// Following should cause the ok button to activate/de-activate
			// according to the state of the report object.
			this._report.Valid += new System.EventHandler(this.CheckValid);
			this._report.Invalid += new System.EventHandler(this.CheckValid);
			this._report.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			this._report.DivisionCode = Common.LogonUser.LogonUserDivisionCode;

			this.AddHandlers();

			this.rdoIssuingPhysician.Checked=true;
		}

		/// <summary>
		/// Get/Set StartDate
		/// </summary>
		public DateTime StartDate
		{
			get
			{
				DateTime startDate = new DateTime(this.dtpStartDate.Value.Year,
					this.dtpStartDate.Value.Month,
					this.dtpStartDate.Value.Day,
					0,
					0,
					0);
				return startDate;
			}
			set
			{
				this.dtpStartDate.Value = value;
			}
		}

		/// <summary>
		/// Get/Set EndDate
		/// </summary>
		public DateTime EndDate
		{
			get
			{
				DateTime endDate = new DateTime(this.dtpEndDate.Value.Year,
					this.dtpEndDate.Value.Month,
					this.dtpEndDate.Value.Day,
					23,
					59,
					59);
				return endDate;
			}
			set
			{
				this.dtpEndDate.Value = value;
			}
		}

		/// <summary>
		/// LoadIssueToLocations
		/// </summary>
		public void LoadIssueToLocations()
		{
			ArrayList issueToLocations = BOL.IssuedUnit.GetIssueToLocationList();

			foreach(string location in issueToLocations)
			{
				if (location.Trim() != "")
					this.lbIssuedToLocations.Items.Add(location);
			}
		}

		/// <summary>
		/// LoadPhysicians
		/// </summary>
		public void LoadPhysicians()
		{
			ArrayList physicians = BOL.IssuedUnit.GetPhysiciansList();

			foreach(string physician in physicians)
			{
				if (physician.Trim() != "")
					this.lbIssuingPhysicians.Items.Add(physician);
			}
		}

		private void CheckDates()
		{
			if (this._report.StartDate > this._report.EndDate)
			{
				this.errError.SetVbecsError(this.dtpEndDate, Common.StrRes.SysErrMsg.Common.CannotbeGreaterError("Start date", "End date").ResString); // **** 508 Compliance ***
			}
			else
			{
				this.errError.SetVbecsError(this.dtpEndDate, ""); // **** 508 Compliance ***
			}
			//
			if (this._report.IsScheduled)
			{
				if (this._report.EndDate > this._report.PrintDate)
				{
					this.errError.SetVbecsError(this.dtpPrintDate, Common.StrRes.SysErrMsg.Common.CannotbeLessError("Print date", "End date").ResString); // **** 508 Compliance ***
				}
				else
				{
					this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
				}
			}
			else
			{
				this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
			}
		}
		
		/// <summary>
		/// Added 1/5/04 RDH
		/// Added method to populate the Printers drop down
		/// list for scheduling.
		/// </summary>
		public void LoadPrinters()
		{
			this.cmbPrinterName.Items.Clear();
			//
			foreach (string printerName in BOL.VbecsReport.GetPrinters())
			{
				cmbPrinterName.Items.Add(printerName);
			}
		}

		/// <summary>
		/// LoadSpecialties
		/// </summary>
		public void LoadSpecialties()
		{
			ArrayList treatingSpecialties = BOL.Patient.GetTreatingSpecialtiesList();

			foreach(string specialty in treatingSpecialties)
			{
				if (specialty.Trim() != "")
					this.lbTreatingSpecialties.Items.Add(specialty);
			}
		}

		private void rdoIssuingPhysician_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpIssuingPhysicians.BringToFront();
			this._report.IssuingPhysicianReport=this.rdoIssuingPhysician.Checked;
			this.reportType = Common.TransfusionReportType.Physician;
		}

		private void rdoTreatingSpecialty_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpTreatingSpecialties.BringToFront();
			this._report.TreatingSpecialityReport=rdoTreatingSpecialty.Checked;
			this.reportType = Common.TransfusionReportType.TreatingSpecialty;
		}

		private void rdoIssuedToLocation_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpIssuedToLocations.BringToFront();
			this._report.IssuedToLocationReport=this.rdoIssuedToLocation.Checked;
			this.reportType = Common.TransfusionReportType.IssueToLocation;
		}

		private void btnDeselectAllSpecialties_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lbTreatingSpecialties, CheckState.Unchecked);
		}

		private void btnSelectAllSpecialties_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lbTreatingSpecialties, CheckState.Checked);
		}

		private void btnDeselectAllLocations_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lbIssuedToLocations, CheckState.Unchecked);
		}

		private void btnSelectAllLocations_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lbIssuedToLocations, CheckState.Checked);
		}

		private void btnDeselectAllPhysicians_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lbIssuingPhysicians, CheckState.Unchecked);
		}

		private void btnSelectAllPhysicians_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lbIssuingPhysicians, CheckState.Checked);
		}

		private void SelectDeselectAll(System.Windows.Forms.CheckedListBox listBox, System.Windows.Forms.CheckState checkState)
		{
			for(int index=0; index<listBox.Items.Count; index++)
			{
				listBox.SetItemCheckState(index,checkState);
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			using( WaitCursor _cursor = new WaitCursor() )
			{
				string whereClause = "";
				string reportCriteria = "";
				
				this._report.StartDate=this.StartDate;
				this._report.EndDate=this.EndDate;

				this._report.IsScheduled=this.rdoScheduleJob.Checked;

				whereClause = this._report.GenerateFilterStatement();

				if (this.rdoTreatingSpecialty.Checked)
					reportCriteria = "Treating Specialties: ";
				else if (this.rdoIssuingPhysician.Checked)
					reportCriteria = "Issuing Physicians: ";
				else if (this.rdoIssuedToLocation.Checked)
					reportCriteria = "Issued To Locations: ";

				reportCriteria += whereClause.Replace("|", ",").Substring(1, whereClause.Length-2);
				
				this._report.FilterStatement=whereClause;

				if (this._report.IsScheduledReportGreaterThanThirtyDays)
				{
					if (DialogResult.Yes != GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.ScheduledReportGreaterThanThirtyDays()))
					{
						return;
					}
				}

				// Added 1/5/04 RDH
				// The following if/else statements were added
				// For scheduling a report.
				if(this._report.IsScheduled)
				{
					this._report.PrinterName=this.cmbPrinterName.Text;
					this._report.PrintDate=this.dtpPrintDate.Value;  
					this._report.Schedule();

					this.DialogResult = DialogResult.Cancel;
				}
				else
				{

					DataSet dsTransfusions = this._report.GenerateTransfusionReportSource();				

					int recordCount = dsTransfusions.Tables[0].Rows.Count;
					if (recordCount == 0)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC077.NoRecordsFound());
						return;
					}
					else if(recordCount/10 > 50)
					{
						DialogResult _result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
						if( _result != DialogResult.Yes )
						{
							return;
						}
						else
						{
							//Alert user that building report may take a few minutes
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.Warning());
						}
					}

					FrmTransfusionReport frm = new FrmTransfusionReport(dsTransfusions, reportType, this.StartDate, this.EndDate, reportCriteria);
					frm.MdiParent = this._mdiParent;
					frm.Show();
				}
				this.Close();
			}
		}

		private void lbTreatingSpecialties_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if(e.NewValue==System.Windows.Forms.CheckState.Checked)
				this._report.AddSpecialty(lbTreatingSpecialties.Items[e.Index].ToString());
			else
				this._report.RemoveSpecialty(lbTreatingSpecialties.Items[e.Index].ToString());
			
			this.CheckValid(this, System.EventArgs.Empty);
		}

		private void lbIssuingPhysicians_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if(e.NewValue==System.Windows.Forms.CheckState.Checked)
				this._report.AddPhysician(lbIssuingPhysicians.Items[e.Index].ToString());
			else
				this._report.RemovePhysician(lbIssuingPhysicians.Items[e.Index].ToString());

			this.CheckValid(this, System.EventArgs.Empty);
		}

		private void lbIssuedToLocations_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if(e.NewValue==System.Windows.Forms.CheckState.Checked)
				this._report.AddLocation(lbIssuedToLocations.Items[e.Index].ToString());
			else
				this._report.RemoveLocation(lbIssuedToLocations.Items[e.Index].ToString());
			
			this.CheckValid(this, System.EventArgs.Empty);
		}

		private void dtpStartDate_ValueChanged(object sender, System.EventArgs e)
		{
			this._report.StartDate = this.dtpStartDate.Value;
			//
			CheckDates();
		}

		private void dtpEndDate_ValueChanged(object sender, System.EventArgs e)
		{
			this._report.EndDate = this.dtpEndDate.Value;
			//
			CheckDates();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		// Added 1/5/04 
		// Method is for activating and de-activating the Shedule Job
		// group box and it's contents.
		private void rdoScheduleJob_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpScheduleJob.Enabled = (this.rdoScheduleJob.Checked);
			this._report.IsScheduled = this.rdoScheduleJob.Checked;
			if ((this._report.IsScheduled) && (this._report.PrintDate == DateTime.MinValue))
			{
				this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			}
		}

		// Added 1/5/04 RDH Copied from UC 48. Used to handle
		// the enabling of the ok button.
		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = ( this._report.IsValid );
		}

		private void dtpPrintDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				this._report.PrintDate = this.dtpPrintDate.Value;
			}
			//
			CheckDates();
		}

		private void cmbPrinterName_SelectedValueChanged(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				if(cmbPrinterName.SelectedItem!=null)
				{
					string printer=this.cmbPrinterName.Text;
					for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
					{
						if(printer==this.cmbPrinterName.Items[i].ToString())
						{
							this._report.PrinterName = cmbPrinterName.SelectedItem.ToString();
						}
					}
				}		
				else
				{
					this._report.PrinterName=String.Empty;
				}
			}
		}
		
		private void HoverOK(object sender, System.EventArgs e)
		{
			if (this._report.IsValid)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(this._report.GetBrokenRulesMessage(gov.va.med.vbecs.Common.VbecsBrokenRules.TransfusionReport.FormClassName));
			}
		}

		private void AddHandlers()
		{
			this.rdoIssuedToLocation.CheckedChanged += new System.EventHandler(this.rdoIssuedToLocation_CheckedChanged);
			this.rdoTreatingSpecialty.CheckedChanged += new System.EventHandler(this.rdoTreatingSpecialty_CheckedChanged);
			this.rdoIssuingPhysician.CheckedChanged += new System.EventHandler(this.rdoIssuingPhysician_CheckedChanged);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.dtpStartDate_ValueChanged);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.dtpEndDate_ValueChanged);
			this.btnSelectAllSpecialties.Click += new System.EventHandler(this.btnSelectAllSpecialties_Click);
			this.btnDeselectAllSpecialties.Click += new System.EventHandler(this.btnDeselectAllSpecialties_Click);
			this.btnSelectAllPhysicians.Click += new System.EventHandler(this.btnSelectAllPhysicians_Click);
			this.btnDeselectAllPhysicians.Click += new System.EventHandler(this.btnDeselectAllPhysicians_Click);
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.rdoScheduleJob_CheckedChanged);
			this.cmbPrinterName.SelectedValueChanged += new System.EventHandler(this.cmbPrinterName_SelectedValueChanged);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.dtpPrintDate_ValueChanged);
			this.btnSelectAllLocations.Click += new System.EventHandler(this.btnSelectAllLocations_Click);
			this.btnDeselectAllLocations.Click += new System.EventHandler(this.btnDeselectAllLocations_Click);
			this.lbIssuedToLocations.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lbIssuedToLocations_ItemCheck);
			this.lbTreatingSpecialties.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lbTreatingSpecialties_ItemCheck);
			this.lbIssuingPhysicians.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lbIssuingPhysicians_ItemCheck);

			this.rdoIssuedToLocation.CheckedChanged += new System.EventHandler(this.CheckValid);
			this.rdoTreatingSpecialty.CheckedChanged += new System.EventHandler(this.CheckValid);
			this.rdoIssuingPhysician.CheckedChanged += new System.EventHandler(this.CheckValid);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.CheckValid);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.CheckValid);
			this.btnSelectAllSpecialties.Click += new System.EventHandler(this.CheckValid);
			this.btnDeselectAllSpecialties.Click += new System.EventHandler(this.CheckValid);
			this.btnSelectAllPhysicians.Click += new System.EventHandler(this.CheckValid);
			this.btnDeselectAllPhysicians.Click += new System.EventHandler(this.CheckValid);
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.CheckValid);
			this.cmbPrinterName.SelectedValueChanged += new System.EventHandler(this.CheckValid);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.CheckValid);
			this.btnSelectAllLocations.Click += new System.EventHandler(this.CheckValid);
			this.btnDeselectAllLocations.Click += new System.EventHandler(this.CheckValid);
			this.btnOK.MouseHover +=new EventHandler(HoverOK);
		}
	}
}

